/* textfmt.c
   This program tests console text formatting.
   Usage: textfmt
   change log:
   12/28/2024 initial version
   01/20/2025 moved fputs to dylib
*/

#include <stdio.h>
#include <dylib.h>

int main (int argc, char *argv[]) {

   int i;
   char c;

   for (i = 0; i < 50; i++) {
      dylib.fputs ("\fform feed\n", stdout);
   }

   dylib.fputs ("line feed\n", stdout);
   for (i = 0; i < 5; i++) {
      fprintf (stdout, "%d\n", i);
   }

   dylib.fputs ("carriage return\n", stdout);
   for (i = 0; i < 1024; i++) {
      fprintf (stdout, "\r%d", i);
   }
   dylib.fputs ("\n", stdout);

   dylib.fputs ("backspace\n", stdout);
   dylib.fputs ("   > ", stdout);
   for (i = 0; i < 10; i++) {
      for (c = 33; c < 127; c++) {
         fprintf (stdout, "\b%c", c);
      }
   }
   dylib.fputs ("\n", stdout);

   
   return 0;
}
