/* hello.c
   This program provides a simple hello world implementation to demonstrate
   the simplest possible program that does something.
   change log:
   07/27/2023 initial version
   08/14/2023 simplified code down to the "standard" hello world in proper C form.
   01/20/2025 moved fputs to dylib
*/

#include <stdio.h>
#include <string.h>
#include <console.h>
#include <dylib.h>

void clock_start () {
   __asm__(
      "       CLR  r12         ; CRU base of the TMS9901\n"
      "       SBO  0           ; Enter timer mode\n"
      "       LI   r1,0x3FFF   ; Maximum value\n"
      "       INCT r12         ; Address of bit 1\n"
      "       LDCR r1,14       ; Load value\n"
      "       DECT r12         ; TBD\n"
      "       SBZ  0           ; Exit clock mode and start decrementer" : : : "r1", "r12"
   );              
}

void clock_read (int *v) {
   int k = 99;
   __asm__(
      "       CLR  r12         ; CRU base of the TMS9901\n"
      "       SBO  0           ; Enter timer mode\n"
      "       STCR r2,15       ; Read current value (plus mode bit)\n"
      "       SRL  r2,1        ; Get rid of mode bit\n"
      "       LDCR r12,15      ; Clear Clock register, and exit timer mode\n"
      "       MOV  r2,%0\n" : "=r"(k) : : "r2", "r12"
   );
   *v = k;
}

int main (int argc, char *argv[]) {
   dylib.fputs.c ("hello world!\n", stdout); // print hello world

   int v = 0;


   for (int i = 0; i < 16; i++) {
      clock_start ();
      dylib.fputs.c (".............", stdout);
      for (int j = 0; j < i * 1024; j++);
      clock_read (&v);
      dylib.fputs.c (int2str (v), stdout);
      dylib.fputs.c ("\n", stdout);
   }

   return 0;                         // return success
}
