import logging
import evdev
import threading
import queue
import time

logger = logging.getLogger(__name__)

class MouseAvailablePlugin(object):
    def __init__(self):
        logger.info('created mouse_available plugin instance')
        self.mouse_available = False

    def find_mouse(self):
        self.mouse_available = False
        devices = [evdev.InputDevice(path) for path in evdev.list_devices()]
        for device in devices:
            logger.info(f'examining device: {device.name}')
            if 'mouse' in device.name.lower():
                self.mouse_available = True
                logger.info(f'mouse found: {device.name}')
                break
        time.sleep (0.1)

    def handle(self, bytes):
        try:
            self.find_mouse()
            if self.mouse_available:
                r = 1
            else:
                r = 0

            logger.info(f'handled mouse_available plugin message, returning {r}')
            return [r]

        except Exception as e:
            logger.error(f'something went wrong: {e}')
            return []
