/* touch.c
   This program accesses an existing file or creates it if it doesn't exist.
   Usage: touch file [... filen]
   limitations
   - only works with binary files and / or generates binary files
   change log:
   05/23/2025 initial version
*/ 

#include <util.h>
#include <stdio.h>
#include <dylib.h>

int main (int argc, char *argv[]) {

   int r = 0;

   FILE *f;

   for (int i = 1; i < argc; i++) {
      f = dylib.fopen (argv[i], "rb+");
      if (f) {
         dylib.fclose (f);
      } else {
         f = dylib.fopen (argv[i], "wb");
         if (f) {
            dylib.fclose (f);
         } else {
            dylib.fputs ("touch: ", stderr);
            dylib.fputs (argv[i], stderr);
            dylib.fputs (": No such file or directory\n", stderr);
            r = 1;
         }
      }
   }

   return r;
}
