/* unix99logo.c
   This program displays the unix99 logo.
   change log:
   12/26/2024 initial version
   12/31/2024 updated to output a terminating blank line
   01/17/2025 added call to image_init 
   01/18/2025 updated date to 2025
   01/20/2025 moved fputs to dylib
*/

#include <stdio.h>
#include <utsname.h>
#include <image.h>
#include <console.h>
#include <dylib.h>

// displays the startup banner
int main (int argc, char *argv[]) {

   const char *ti_logo[] = {                                   // ti logo
      "-------XXXXXXX----------",
      "------XX-----X--X-------",
      "------XX-----X-X-X------",
      "------XX-----X-X-X------",
      "------XX-----X--X-------",
      "------XX-----XX---------",
      "------XX------X-----XX--",
      "------XX----XX-----X--X-",
      "XXXXXXXX---XX--XX-XXX-X-",
      "X---------X----XX---X-X-",
      "XX--------X----XX---X-X-",
      "-X--------XXXX-XX-XXX-X-",
      "-XX----------X-XX-X----X",
      "--XXX--------X-XX-X----X",
      "---XXX-------X-XX-X----X",
      "----XXX-XX---X----X---X-",
      "------XXXXX---X--X--XX--",
      "-------X--XX---XX--X----",
      "-----------X------X-----",
      "-----------XX----X------",
      "------------XX---X------",
      "-------------XXX--X-----",
      "--------------XXXXX-----",
      "------------------------",
      NULL
   };

   const char *van_logo[] = {                                  // van electronics logo
      "XXX-----XXXXXXXXXXXXX",
      "--X-----X------------",
      "---X---X--XXX---X-XX-",
      "---X---X-----X--XX--X",
      "----X-X---XXXX--X---X",
      "----X-X--X---X--X---X",
      "-----X----XXXX--X---X",

      NULL
   };

   image_init ();

   image_t image_ti_logo;                                      // the ti logo image
   int r;
   r  = image_generate (&image_ti_logo, ti_logo);              // generate the ti logo displayable image
   if (r) {                                                    // test for failure
      dylib.fputs ("error generating ti logo image\n", stdout);
   }

   image_t image_van_logo;                                     // the van logo image
   r = image_generate (&image_van_logo, van_logo);             // generate the van logo displayable image
   if (r) {                                                    // test for failure
      dylib.fputs ("error generating van logo image\n", stdout);
   }

   struct utsname uinfo;                                       // utsinfo
   uname (&uinfo);                                             // capture the data

                                                               // write all the text leaving room for the graphics
   dylib.fputs ("\n     ", stdout);                            // write a blank line and space over
   dylib.fputs (uinfo.version, stdout);                        // write the uts info version
   dylib.fputs ("\n", stdout);                                 // advance with multiple line feeds
   dylib.fputs ("     2025      Electronics\n", stdout);       // write the author info

   int x, y;
   console_get_pos (&x, &y);                                   // get the current cursor positio

   image_draw (&image_ti_logo, y - 3, 0);                      // draw the ti logo image at offset of the cursor position
   image_draw (&image_van_logo, y - 1, 10);                    // draw the van logo image at offset of the cursor position

   dylib.fputs ("\n", stdout);                                 // output a final blank line

   return 0;
}
