/* unix99r3_rom0_start.c
   This method is the direct entry point for executing the program on rom page 0.
   Note that the filename and method are different names. the common trampoline code 
   uses the same entry point for all rom paged programs
   change log:
   01/16/2025 initial version
   01/17/2025 integrated unix99r2 code appropriately for rom 0 and 1 distribution
   01/22/2025 performance improvements
   01/24/2025 moved dsr_hardware_wait here
              removed dir_init
   01/25/2025 renamed kernel_console_font_load
   04/21/2025 added external mouse and keyboard support
   04/24/2025 updated keyboard.h to private
   05/03/2025 updated mouse.h to mouse_private.h
   05/04/2025 added call to tipi_init
   06/14/2025 removed external keyboard and mouse initialization from the kernel
   06/16/2025 modified to call execute rom 3 (from 1)
   07/05/2025 added printing of page and value
              added clearing of the display area where boot text will be printed
   08/25/2025 added call to kernel_console_disable_quit_key
   09/29/2025 disabled the DSR hardware wait
*/

#include <vdp.h>
#include <sams_private.h>
#include <cache_private.h>
#include <dirent_private.h>
#include <stdlib.h>
#include <console_private.h>
#include <tipi_msg.h>

// forward declaration for the common "trampoline" entry point for executing the program on rom page 1.
void romctl_exec_bank_3 ();

void unix99r3_rom_start () {

   kernel_console_font_load ();
   vdpmemset (0x0000, 0x20, 768);
   const char rom_ctrl_start_msg[] = "UNIX99r3 booting...";
   vdpmemcpy (0x0000, (unsigned char *) rom_ctrl_start_msg, sizeof (rom_ctrl_start_msg));
   vdpmemcpy (0x0019, (unsigned char *) "pg 0", 4);

   // cannot return to caller as the call stack will be moved into oblivion 
   // once the sams device is initialized, where memory pages are moved around

   // initialize the sams memory device
   sams_init ();

   // initialize the memory cache
   cache_init ();

   // initialize the atexit data
   atexit_init ();

   // initialize the sequencer -- this will address VDP polling, sound queue playing, speech queue playing, possibly sprite motion
   sequencer_init ();

   // initialize the dsr list
   dsr_list_load ();

   // initialize file handling
   file_init ();

   // initialize dsrs
   // dsr_hardware_wait_for_ready ();

   // disable the quit key
   kernel_console_disable_quit_key ();

   // initialize tipi. This call forces the tipi messaging api to configure upon first use. The swapping of RAM pages in configuring
   // SAMS wipes away the initializaiton performed at startup of this ROM-based program.
   tipi_init ();

   // call the program in rom page 3
   romctl_exec_bank_3 ();
}
