/* unix99r3_rom1_start.c
   This method is the direct entry point for executing the program on rom page 1.
   Note that the filename and method are different names. the common trampoline code 
   uses the same entry point for all rom paged programs
   change log:
   01/16/2025 initial version
   01/17/2025 added unix99r2 code distributed appropriately for rom 0 and 1
   01/24/2025 moved dsr_hardware_wait_for_ready to rom0
   06/16/2025 added call to set '1' on the boot screen signifying the rom
*/

#include <dylib_private.h>
#include <vdp.h>
#include <stdlib.h>
#include <stdio_private.h>
#include <unistd_private.h>

void unix99r3_rom_start () {

   vdpmemset (0x001d, '1', 1);

   // perform the dynamic library link for this ROM page
   dylib_rom1_link ();

   // do some final something as an example
   const char rom_ctrl_done_msg[] = "done";
   vdpmemcpy (0x0013, (unsigned char *) rom_ctrl_done_msg, sizeof (rom_ctrl_done_msg));

   // transfer control to the first ea5 executable
   exec_uea5 ("/bin/launchd");

   // this should never be reached so can be removed once this program is complete
   while (1);
}
