/* unix99r3_romctl.c
   These methods are the common "trampoline" section in all rom pages. It allows any
   rom page program to call another's entry.
   change log:
   01/16/2025 initial version
   01/25/2025 included rom_private.h for rom bank switching addresses
   06/16/2025 added exec for banks 2 and 3
*/

#include <rom_private.h>
#include <vdp.h>

// forward declaration of each rom page's entry point
void unix99r3_rom_start ();

// entry point for page 0
void romctl_exec_bank_0 () {

   // set the rom page to 0
   BSWITCH_0 = 1;

   // call the page's entry point
   unix99r3_rom_start ();
}

// entry point for page 1
void romctl_exec_bank_1 () {

   // set the rom page to 1
   BSWITCH_1 = 1;

   // call the page's entry point
   unix99r3_rom_start ();
}

// entry point for page 2
void romctl_exec_bank_2 () {

   // set the rom page to 2
   BSWITCH_2 = 1;

   // call the page's entry point
   unix99r3_rom_start ();
}

// entry point for page 3
void romctl_exec_bank_3 () {

   // set the rom page to 3
   BSWITCH_3 = 1;

   // call the page's entry point
   unix99r3_rom_start ();
}

// main C entry point for unix99r3 
void unix99r3_romctl () {

   romctl_exec_bank_0 ();

   // control never returns 
}
