# unix99r3_start_cart.asm
# This method defines the entry point for C runtime initialization code.
# change log:
# 06/01/2023 initial version
# 09/06/2023 modified to call cartridge-specialized start method.
# 02/28/2024 updated to reset the cache validity flag
#            added _reload
# 03/07/2024 updated to call start_rom rather than start_cart
# 01/12/2025 removed _reload
# 01/16/2025 renamed to unix99r3_start_cart
#            updated to call unix99r3_romctl

 def _start
 def _reload
 def _init_data

# Initial entry point from TI boot main screen's cartridge start menu
_start:
   li   r0, >0000      # load the value to reset the cache validity flag
   mov  r0, @>2000     # copy the value to the cache validity flag

#_reload:
# Initial entry point for C runtime initilization code
#
# This will set initial values for data memory and otherwise create
# the conditions needed for the C environment
# Disable interrupts
#
# This will disable console reset via keyboard, music playback,
# sprite automotion, etc. But will make the environment much simpler
# to work in. Users can re-enable interrupts later if they wish.
  limi 0

# Set initial workspace
#
# The registers will be located at the start of scratchpad memory 
  lwpi >8300

# Initialize data segment to known values
  li   r0, _init_data  # Point to data initialization structure
  mov  *r0+, r1        # R1 = Start of data section
  mov  *r0+, r2        # R2 = Location of initial data
  mov  *r0+, r3        # R3 = Size of data section
  jeq  data_copy_end   # If size is 0, skip the loop
  
  # Copy loop for data initialization
data_copy_top:
  mov  *r2+, *r1+      
  dect r3
  jgt  data_copy_top
data_copy_end:

# Initialize BSS segment to zeroes
  mov  *r0+, r1        # R1 = Start of BSS section
  mov  *r0, r2         # R2 = Size of BSS section
  jeq  bss_clear_end   # If size is 0, skip the loop

  # Clearing loop for BSS initialization
bss_clear_top:
  clr  *r1+
  dect r2
  jgt  bss_clear_top
bss_clear_end:

# Create the stack (R10)
  li sp, >4000

# Start running C code
  bl @unix99r3_romctl

# reset the console on return
  blwp @>0000

# Data initialization structure
#
# This structure will be filled in by the ELF conversion program
# after link time.
_init_data:
  data >5f69  # Start of data section;                        _i
  data >6e69  # Location of initial contents of data section; ni
  data >745f  # Size of data section;                         t_
  data >6461  # Start of BSS section;                         da
  data >7461  # Size of BSS section;                          ta

