/* extract_subimage.c
   This program extracts a subimage from the pattern and color files produced by Tursi's (Harmless Lion) image conversion tool.
   The format is quite simple:
   height (2 bytes)
   width (2 bytes)
   pattern table values (width * height * 8 bytes)
   color table values (width * height * 8 bytes)
   change history
   01/26/2025 initial version
*/

#include <stdlib.h>
#include <stdio.h>

int main (int argc, char *argv[]) {

   char *in_file1 = argv[1];
   char *in_file2 = argv[2];
   char *out_file = argv[3];
   int top = atoi (argv[4]);
   int left = atoi (argv[5]);
   int height = atoi (argv[6]);
   int width = atoi (argv[7]);
   unsigned int t;
   int n;

   FILE *fin = fopen (in_file1, "r");
   FILE *fout = fopen (out_file, "w");
   unsigned char buffer[256];

   void *x;
   
   buffer[0] = 0;
   fwrite (buffer, 1, 1, fout);

   t = height;
   x = &t;
   fwrite (x, 1, 1, fout);

   buffer[0] = 0;
   fwrite (buffer, 1, 1, fout);

   t = width;
   x = &t;
   fwrite (x, 1, 1, fout);

   for (int i = 0; i < 2; i++) {
      for (int y = top; y < top + height; y++) {
         fseek (fin, (y << 8) + (left << 3), SEEK_SET);
         n = fread (buffer, 1, width << 3, fin);
         fwrite (buffer, 1, n, fout);
      }

      fclose (fin);
      if (i == 0) {
         fin = fopen (in_file2, "r");
      }
   }

   fclose (fout);

   return 0;
}
