/* xkb_drv.c
   This method sets the external keyboard status based on availabilty and calling parameters. External keyboard usage requires
   TIPI and an attached keyboard.
   change history
   06/14/2025 initial version
   06/16/2025 updated exit reference
*/

#include <stdio.h>
#include <cache_private.h>
#include <keyboard_private.h>
#include <unistd.h>
#include <dylib.h>
#include <stdlib.h>

void display_usage () {
   dylib.fputs ("usage: xkb_drv [-d] [-e]\n", stderr);
}

int main (int argc, char *argv[]) {

   bool enable = true;

   // capture the options
   int opt;   
   int error = false;
   while ((opt = getopt (argc, argv, "de")) != -1) {
      switch (opt) {
         case 'd': 
            enable = false;
            break;
         case 'e': 
            enable = true;
            break;
         case '?':   
         default:
            error = true;
            break;
      }
   }

   if (error) {
      display_usage ();
      exit (1);      
   }

   // adjust argc and argv removing the processed options
   argc -= optind;
   argv += optind;

   cachex.have_external_keyboard = enable && !keyboard_init ();

   return 0;
}
